//*********************************************************************************
//**
//** Project.........: Magnetic Loop Controller
//**
//**
//**
//** Platform........: AT90usb1286 @ 16MHz
//**
//** Licence.........: This software is freely available for non-commercial 
//**                   use only - i.e. for research and experimentation.
//**
//** Initial version.: 2012-10-20, Loftur Jonasson, TF3LJ / VE2LJX
//**
//**
//** History.........: Check the ML.c file
//**
//*********************************************************************************

//
// This code makes use of the LUFA library for USB connectivity
//
/*
             LUFA Library
     Copyright (C) Dean Camera, 2012.

  dean [at] fourwalledcubicle [dot] com
           www.lufa-lib.org
*/

/*
  Copyright 2012  Dean Camera (dean [at] fourwalledcubicle [dot] com)

  Permission to use, copy, modify, distribute, and sell this
  software and its documentation for any purpose is hereby granted
  without fee, provided that the above copyright notice appear in
  all copies and that both that the copyright notice and this
  permission notice and warranty disclaimer appear in supporting
  documentation, and that the name of the author not be used in
  advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  The author disclaim all warranties with regard to this
  software, including all implied warranties of merchantability
  and fitness.  In no event shall the author be liable for any
  special, indirect or consequential damages or any damages
  whatsoever resulting from loss of use, data or profits, whether
  in an action of contract, negligence or other tortious action,
  arising out of or in connection with the use or performance of
  this software.
*/

#include 	<math.h>
#include	"ML.h"
#include 	"USB/USBtoSerial.h"				// LUFA include


char lcd_buf[20];

//
//-----------------------------------------------------------------------------------------
// 			Throw a character onto the USB bus queue (128 char ringbuffer)
//-----------------------------------------------------------------------------------------
//
void usb_send_char(uint8_t input)
{
	// LUFA USB library function, used with the USBtoSerial stuff
	RingBuffer_Insert(&USARTtoUSB_Buffer, input);
}



//
//-----------------------------------------------------------------------------------------
// 			Display Frequency as XX.XXX.XXX
//-----------------------------------------------------------------------------------------
//
void display_frq(int32_t frq)
{
	int32_t f1, f2, f3;					// Used to format frequency printout	
	f1 = frq/1000000;
	f3 = frq%1000000;
	f2 = f3/1000;
	f3 = f3%1000;
	sprintf(lcd_buf,"%2u.%03u.%03u",(uint16_t)f1,(uint16_t)f2,(uint16_t)f3);
	lcdPrintData(lcd_buf, strlen(lcd_buf));
}


//
//-----------------------------------------------------------------------------
//			Display Stepper Position
//			Indicate number of revolutions above lowest preset
//-----------------------------------------------------------------------------
//
void display_stepper_pos(int32_t pos)
{
	int8_t sign;
	double pos_rev;

	if (R.presetPos[1]>R.presetPos[0]) sign = 1;	// Normalise +/-
	else sign = -1;
	
	pos_rev = sign*(pos - R.presetPos[0])/1600.0;
	if ((pos_rev >= 0) && (pos_rev < 10))
	lcdDataWrite(' ');
	sprintf(lcd_buf,"%2.03f", pos_rev);
	lcdPrintData(lcd_buf, strlen(lcd_buf));
}


//
//-----------------------------------------------------------------------------
//			Display Bargraph meter
//-----------------------------------------------------------------------------
//
/*void lcd_display_bargraph_full(void)
{
	int16_t	db10;
	static uint8_t mode_timer = 0;

	db10 = (int16_t) (power_db*10.0);
	
	lcdClear();

	//------------------------------------------
	// Display mode intro for one second
	if(Status & MODE_DISPLAY)
	{
		if(Status & MODE_CHANGE)
		{
			Status &= ~MODE_CHANGE;			// Clear display change mode
			mode_timer = 0;					// New mode, reset timer
		}
		lcdGotoXY(0,0);
		rprintf("Bargraph Meter->");
		lcdGotoXY(0,1);
		rprintf("(average power)");
		mode_timer++;
		if (mode_timer == 10)
		{
			mode_timer = 0;
			Status &= ~MODE_DISPLAY;		// Clear display change mode
		}
	}
	else
	{
		//------------------------------------------
		// Power indication, dBm average
		lcdGotoXY(0,0);
		print_dbm(db10);

		//------------------------------------------
		// Power indication, average
		lcdGotoXY(9,0);
		print_p_mw(power_mw);

		//------------------------------------------
		// Bargraph
		lcdGotoXY(0,1);
		lcdProgressBar((db10 + BAR_MIN_VALUE), BAR_FULL_RANGE, BAR_LENGTH);
	}
}
*/

//
//-----------------------------------------------------------------------------
//			Display a Mixed bag of irrelevant stuff
//-----------------------------------------------------------------------------
//
/*void lcd_display_mixed(void)
{
	double 	output_voltage;
	uint16_t power, power_sub;
	
	lcdClear();

	lcdGotoXY(0,0);
	rprintf("Dbg:");

	//------------------------------------------
	// AD8307 voltage indication
	lcdGotoXY(4,0);
	output_voltage = ad8307_ad * 4 / 1000.0;
	power_sub = output_voltage * 1000;
	power = power_sub / 1000;
	power_sub = power_sub % 1000;
	rprintf("%u.%03uV %4u", power, power_sub, ad8307_ad);	

	//------------------------------------------
	// Calibrate 1
	lcdGotoXY(0,1);
	//	print_dbm(R.calibrate[0].db10m);
	rprintf ("%3d",R.calibrate[0].db10m);
	rprintf ("%4u",R.calibrate[0].ad);

	//------------------------------------------
	// Calibrate 2
	//	print_dbm(R.calibrate[1].db10m);
	lcdGotoXY(8
	,1);
	rprintf ("%4d",R.calibrate[1].db10m);
	rprintf ("%4u",R.calibrate[1].ad);
}
*/

//
//-----------------------------------------------------------------------------------------
// 			Send AD8307 measurement data to the Computer
//-----------------------------------------------------------------------------------------
//
/*void usb_send_data(void)
{
//	uint8_t i = 0;

	// Init AVRLIB rprintf() against the USB
	rprintfInit(usb_send_char);

	//------------------------------------------
	// Power indication, dBm average (1 second window)
	print_dbm((int16_t) (power_db*10.0));
	rprintf("_AVG, ");

	//------------------------------------------
	// Power indication, dBm pep (1 second window)
	print_dbm((int16_t) (power_db_pep*10.0));
	rprintf("_PEP, ");

	//------------------------------------------
	// Power indication, average (1 second window)
	print_p_mw(power_mw);
	rprintf("_AVG, ");

	//------------------------------------------
	// Power indication, 1 second PEP
	print_p_mw(power_db_pep);
	rprintf("_PEP, ");

	//------------------------------------------
	// Amplitude Modulation Index
	rprintf("%3u",modulation_index);
	rprintfChar('%');
	rprintf("_AM\r\n");

	// Return the AVRLIB rprintf() to the LCD
	rprintfInit(lcd_data);
}*/

